//
//  OPWatchtowerDatabase.h
//  ApplicationFrameworks
//
//  Created by Kevin Hayes on 2015-10-30.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>

@interface OPWatchtowerDatabase : NSObject

@property (nonatomic, strong) NSOperationQueue *queue;

+ (void)setActiveWatchtowerDatabase:(OPWatchtowerDatabase *)database;
+ (OPWatchtowerDatabase *)activeWatchtowerDatabase;

- (id)initWithURL:(NSURL *)URL;
- (void)closeDatabase;
- (BOOL)openDatabaseWithError:(NSError **)error;
- (BOOL)isDatabaseOpen;

- (OPDomainVulnerabilityAction)selectVulnerabilityActionForItem:(OPItem *)item;
- (void)updateVulnerabilityActionForItem:(OPItem *)item;

@end
